const camelToDashMap = new Map();
export function camelToDash(str) {
  let result = camelToDashMap.get(str);
  if (result === undefined) {
    result = str.replace(/([a-z])([A-Z])/g, "$1-$2").toLowerCase();
    camelToDashMap.set(str, result);
  }
  return result;
}

export function pascalToDash(str) {
  return camelToDash(str.replace(/((?!([A-Z]{2}|^))[A-Z])/g, "-$1"));
}

export function dispatch(host, eventType, options = {}) {
  return host.dispatchEvent(
    new CustomEvent(eventType, { bubbles: false, ...options }),
  );
}

export function shadyCSS(fn, fallback) {
  const shady = window.ShadyCSS;

  /* istanbul ignore next */
  if (shady && !shady.nativeShadow) {
    return fn(shady);
  }

  return fallback;
}

export function stringifyElement(target) {
  return `<${String(target.tagName).toLowerCase()}>`;
}

export const deferred = Promise.resolve();

export const storePointer = new WeakMap();
